// // Copyright (c) 2022 - 2023 Asadeus Studios LLC.  All rights reserved.

#pragma once

#include "PnmsAdvancedSystemPublicPCH.h"
#include "UObject/Interface.h"
#include "Types/AmsTypes.h"
#include "IAmsMountableActor.generated.h"

// This class does not need to be modified.
UINTERFACE(MinimalAPI)
class UAmsMountableActorInterface : public UInterface
{
	GENERATED_BODY()
};

/**
 * Interface for any actor that is considered a Mountable Actor, additional functionality added based on Need of Game
 */
class PNMSADVANCEDSYSTEM_API IAmsMountableActorInterface
{
	GENERATED_BODY()

public:

	/**
	* Get the type of Mount the implementing actor is considered.
	*/
	UFUNCTION(BlueprintNativeEvent, BlueprintCallable, Category="IAmsMountableActor")
	EAmsMountTypes GetMountType() const;

	/**
	* Called when the the mount driver dismounts
	*/
	UFUNCTION(BlueprintNativeEvent, BlueprintCallable, Category = "IAmsMountableActor")
	void OnMountDriverDismounted();

	IMPLEMENT_INTERFACE(UAmsMountableActorInterface);
};
