// Copyright (c) 2019 - 2023 Asadeus Studios LLC.  All rights reserved.

/**
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
	THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE DISCLAMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
	BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION).  HOWEVER, CAUSED AND ON ANY THEORY OF LIABILITY, WHEATHER IN CONTRACT, STRICT
	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
*/

#pragma once

#include "System/MountingTypes.h"

// Generated Includes
#include "AmsTypes.generated.h"

// Enums
///////////////////////////////////////////////////////////////////////////////////

/**
* Enum of Mounting Directions for a Mountable Pawn
*/
UENUM(BlueprintType)
enum class EAmsMountTypes : uint8
{
	// Invalid
	Invalid = 0		UMETA(DisplayName = "Invalid"),

	// Any Side
	Character = 1	UMETA(DisplayName = "Character"),

	// Right Side
	RidingAnimal = 10	UMETA(DisplayName = "Riding Animal"),

	// Left Side
	BuggyCar = 20	UMETA(DisplayName = "Buggy"),

	// Front Side
	MediumCar = 30	UMETA(DisplayName = "MediumCar"),

	// Back Side
	FlyingShip = 100	UMETA(DisplayName = "Flying Ship"),

	// Max for Iteration
	MAX					UMETA(Hidden)
};

// Structs
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
* Data describes how a given seat may be mounted by a rider, where the mounting point to start at is and what valid direction it represents
* Seats may have multiple entries for this data for different sides that may be mounted to.
*/
USTRUCT(Blueprintable, BlueprintType, Atomic)
struct PNMSADVANCEDSYSTEM_API FAmsMountAnimationData
{
	GENERATED_BODY()

public:

	FAmsMountAnimationData()
	{}

	// Dev Friendly name to help organize and configure
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat")
	FName MountingInfoName = NAME_None;

	// The mount type the animation is for
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat")
	EAmsMountTypes MountType = EAmsMountTypes::Invalid;

	// The relative position Valid to where the mounting or dismounting should take place
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat")
	EMountingDirection RelativeDirection = EMountingDirection::InvalidSide;

	// Mounting Montage to play for this particular mounting type.
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat")
	class UAnimMontage * Montage = nullptr;
};

/**
* Data describes how a given seat may be mounted by a rider, where the mounting point to start at is and what valid direction it represents
* Seats may have multiple entries for this data for different sides that may be mounted to.
*/
USTRUCT(Blueprintable, BlueprintType, Atomic)
struct PNMSADVANCEDSYSTEM_API FAmsChangeSeatAnimationData
{
	GENERATED_BODY()

public:

	FAmsChangeSeatAnimationData()
	{}

	// Dev Friendly name to help organize and configure
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat Anim")
	FName MountingInfoName = NAME_None;

	// The mount type the animation is for
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat Anim")
	EAmsMountTypes MountType = EAmsMountTypes::Invalid;

	// Starting Location of the seat to change from
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat Anim")
	FName StartingSeatName = NAME_None;

	// Ending Location of the seat to be in
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat Anim")
	FName DestinationSeatName = NAME_None;

	// For older setups find the seat by int ID, this is optional if you have named the seats
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat Anim")
	int32 StartingSeatId = -1;

	// For older setups find the seat by int ID, this is optional if you have named the seats
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat Anim")
	int32 DestinationSeatId = -1;

	// Mounting Montage to play for this particular mounting type.
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Seat")
	class UAnimMontage * Montage = nullptr;
};